/*--- change video speed based on switch presses from Arduino
 *
 *  original from Dan Shifman's processing Video Tutorial
 *   https://processing.org/tutorials/video
 *
 *  Setup circuit & Arduino - see documentation in the Arduino Sketch
 * 
 *  modified fred Wolflink @ MassArt 2/22/17
*/

import processing.serial.*; 
import processing.video.*; 

Serial arduino;       // The serial port Arduino is connected to (over USB)
int buttonValue = 0;  // set initial value

Movie movie; 

float speed = 1;

void setup() {  
  size(960, 540);  

  // List all the available serial ports
  printArray(Serial.list());

  // Open the port you are using at the rate you want:
  // update [0] below to match the actual port listed in the console
  // should be /dev/tty.usbmodem1411 on a Mac
  arduino = new Serial(this, Serial.list()[1], 9600);

  movie = new Movie(this, "speed-3.mov");  
  movie.loop();
  movie.speed(1);  // normal speed to start
}

void draw() {
  movie.speed(speed);
  image(movie, 0, 0, 960, 540);
}

/*
  SerialEvent occurs whenever a new data comes in the
 hardware serial RX.  This routine is run between each
 time loop() runs, so using delay inside loop can delay
 response.  Multiple bytes of data may be available.
 */
void serialEvent(Serial arduino) {
  buttonValue = arduino.read();
  if (buttonValue != 0) {
    println(buttonValue);
    howFast();  // use serial data to decide how fast to play
  }
}

void howFast() {
  if (buttonValue == 1) {
    speed = 2;
  }
  if (buttonValue == 2) {
    speed = .25;
  }
}

void movieEvent(Movie m) {  
  m.read();
}

/*
   From the movieEvent Help file in Processing:
 
 This event function is run when a new movie frame is available. 
 Use the read() method to capture this frame. If there is more than one movie in the program, 
 movieEvent() is called each time any of the movies has a new frame available. Use an if to 
 determine which movie is triggering the event. See the above example for implementation details.
 
 This function is for people who want to process the image data separately from drawing 
 (and as quickly as possible.) You cannot draw to the screen inside the movieEvent() function. 
 If you want to draw immediately based on the new image, then use the Movie.available() method. 
*/